// File: test.cpp
//
// Description: This file tests the GUI utility classes
//
// Copyright 1994 by Mark Watson Associates
//
//       No binary rights reserved: this software library may
//       be used in compiled form without restrictions.  All
//       source rights reserved: Source code to the GUI
//       library can not be distributed (on bulletin boards,
//       or as part of shareware or commercial products)
//       without written permission.
//
//       This software is provided "as is". The user accepts
//       all responsibility for its use.
//

#include "applib.h"
#include "Grapher.h"
#include "tplot.h"

// Data definitions for testing TGraph and TPlot classes:
static int nump = 0;
static int xx[10], yy[10];

static TGraph *my_graph = (TGraph *)NULL;
static TPlot *tp = (TPlot *) NULL;
static TPlot *tp2 = (TPlot *) NULL;

static char my_text[100];

//  USER DEFINED CALLBACKS:

void TAppWindow::update_display()
{
    if (my_graph != (TGraph *)NULL)
        my_graph->Draw();
    if (tp != (TPlot *)NULL)
        tp->plot();
    if (tp2 != (TPlot *)NULL)
        tp2->plot();
    for (int i=0; i<nump; i++)
    {
            plot_line(xx[i], yy[i], xx[i]+10, yy[i]+10);
            char buf[22];
            sprintf(buf,"%d",i);
            plot_string(xx[i], yy[i] - 15, buf);
    }
    plot_string(30, 30, Application::text_from_dialog);
}

void TAppWindow::mouse_down(int x, int y)
{
    if (nump < 9)
    {
        xx[nump] = x;
        yy[nump] = y;
        nump++;
    }
    if (my_graph != (TGraph *)NULL)
    {
        int node = my_graph->closestNode(x, y);
        if (node > -1)  my_graph->setSelection(node);
    }
    redraw_display();
}

void TAppWindow::mouse_up(int, int)
{
}

void TAppWindow::mouse_move(int, int)
{
}

void TAppWindow::idle_proc()
{
}

void TAppWindow::do_menu_action(int item_number)
{
    if (item_number == 1)
    {
        nump = 0;
        if (my_graph != (TGraph *)NULL)   delete my_graph;
        my_graph = new TGraph(this, "A");

        my_graph->add_child("B", "A");
        my_graph->add_child("B1", "B");
        my_graph->add_child("B2", "B");
        my_graph->add_child("B22", "B2");
        my_graph->add_child("B221", "B22");
        my_graph->add_child("D", "A");
        my_graph->add_child("E", "D");

        my_graph->do_layout();  // You can layout a graph, then
                                // add new nodes:

        my_graph->add_child("F", "D");
        my_graph->add_child("C", "B");
        my_graph->add_child("C1", "C");
        my_graph->add_child("C2", "C");
        my_graph->add_child("C3", "C");
        my_graph->add_child("C4", "C");
        my_graph->add_child("C5", "C");
        my_graph->add_child("C6", "C");
        my_graph->add_child("CC", "B");
        my_graph->add_child("CC1", "CC");
        my_graph->add_child("CC2", "CC");
        my_graph->add_child("CC3", "CC");
        my_graph->add_child("CC4", "CC");
        my_graph->add_child("CC31", "CC3");
        my_graph->add_child("CC311", "CC31");
        my_graph->add_child("F11", "F");
        my_graph->add_child("C22", "C2");
        my_graph->add_child("G", "E");
        my_graph->add_child("H", "E");
        my_graph->add_child("H1", "H");
        my_graph->add_child("H2", "H");
        my_graph->add_child("H3", "H");
        my_graph->add_child("H11", "H1");
        my_graph->add_child("H12", "H1");

        my_graph->do_layout();

        clear_display();
        update_display();
        redraw_display();
    }
    if (item_number == 2) {
        sprintf(my_text,"this is a test.");
        do_edit("Prompt:", my_text);
    }
    if (item_number == 3)
       show_info(
         "This is a test application for the C++ GUI Library");
    if (item_number == 4) 
    {
        static char *sel_list[] =
              {"option 0", "element 1",
               "this is choice number 2", "pick 3"};
        int ii = choose_one_from_list("Choose something...",
                                      sel_list,4);
        char buf2[255];
        sprintf(buf2,"item selected = %d", ii);
        Warning(buf2);
    }
    if (item_number == 5)
    {
        int ii = choose_one("0", "1");
        char buf2[255];
        sprintf(buf2,"item selected = %d", ii);
        Warning(buf2);
    }
    if (item_number == 6)
    {
        static int need_to_init_text = 1;
        if (need_to_init_text) {
            need_to_init_text = 0;
            init_scrolling_text(90, 180, 180, 33);
//          init_scrolling_text();
        }
        static int countit = 0;
        static char buf2[256];
        sprintf(buf2,
                "This is a test %d     1234567890",
                countit++);
        put_scrolling_text(buf2);
    }
    if (item_number == 7)
    {
        static double xp[30];
        static double yp[30];
        for (int i=0; i<30; i++)
        {
            double x = i - 12;
            double y = 0.2*x*x*x*x*x - 4.0 * x*x*x*x +
                         11.0 * x*x*x - 5.0*x*x - 7;
            xp[i] = x;
            yp[i] = y;
        }
        tp = new TPlot(Application::get_TAppWindow(),
                       "A title",xp,yp,30,40,390,170,55);

        static double xp2[30];
        static double **yp2 = new double *[6];
        for (int l=0; l<6; l++)  yp2[l] = new double[30];
        for (int j=0; j<6; j++)
        {
            for (i=0; i<30; i++)
            {
                double x = i - 12 - j;
                double y = 0.001*j*x*x*x*x*x - 4.0 * x*x*x*x +
                             11.0 * x*x*x - 5.0*x*x - 7 +
                             100* x * x * j;
                xp2[i] = x;
                yp2[j][i] = y;
            }
        }
        tp2 = new TPlot(Application::get_TAppWindow(),
                        "Second title",xp2,yp2,6,30,
                        200,390,420,55);

        clear_display();
        update_display();
        redraw_display();
    }
}

static char *menu_items[] =
    {"Test Grapher Class",
     "Get a text string",
     "About this program",
     "Single list box test",
     "Choose one of 2 choices",
     "Test scrolling text",
     "Test plot utilities"};

INIT_PROGRAM("Test program", 7, menu_items)

   // anything can go here
   Application::text_from_dialog[0] = '\0';
   Application::number_of_dialog_list_items = 0;

   RUN_PROGRAM;

}
